import os
import sys
import shutil
import subprocess
import json
import tempfile
import webbrowser
import tkinter as tk
from tkinter import messagebox
MIN_PYVER = (3, 10)
MS_STORE_PRODUCTID = "9NRWMJP3717K"
MS_STORE_URI = f"ms-windows-store://pdp/?productid={MS_STORE_PRODUCTID}"
PYTHON_ORG_URL = "https://www.python.org/downloads/windows/"
def find_executable(cmd):
    return shutil.which(cmd)
def probe_python_cmd(cmd_args):
    try:
        runner = list(cmd_args)
        runner += ["-c", "import sys, json; print(json.dumps([sys.executable, sys.version_info[0], sys.version_info[1]]))"]
        proc = subprocess.run(runner, capture_output=True, text=True, timeout=5)
        out = proc.stdout.strip()
        if not out:
            return None
        e = json.loads(out)
        exe_path, maj, mino = e[0], int(e[1]), int(e[2])
        return (exe_path, maj, mino)
    except Exception:
        return None
def guess_pythons():
    candidates = []
    for tag in ("-3", "-3.12", "-3.11", "-3.10"):
        if shutil.which("py"):
            res = probe_python_cmd(["py", tag])
            if res:
                candidates.append(res)
    names = ["python3.12", "python3.11", "python3.10", "python3", "python"]
    for n in names:
        if shutil.which(n):
            res = probe_python_cmd([n])
            if res:
                candidates.append(res)
    return candidates

def pick_suitable_python(cands):
    for exe, maj, mino in sorted(cands, key=lambda x:(-x[1], -x[2])):
        if (maj, mino) >= MIN_PYVER:
            return exe, (maj, mino)
    return None

def try_run_install_with(python_exe, install_py_path):
    pdir = os.path.dirname(python_exe)
    pythonw = os.path.join(pdir, "pythonw.exe")
    launcher = pythonw if os.path.exists(pythonw) else python_exe
    try:
        subprocess.Popen([launcher, install_py_path], shell=False)
        return True
    except Exception as e:
        try:
            subprocess.Popen([python_exe, install_py_path], shell=False)
            return True
        except Exception:
            return False

def alert_install_python():
    root = tk.Tk()
    root.withdraw()
    if messagebox.askyesno("Python が見つかりません", "このコンピュータに要求される Python が見つかりませんでした。\n\n「はい」で Microsoft Store の Python ページを開きます（簡単インストール）。\n「いいえ」で python.org のダウンロードページを開きます。"):
        webbrowser.open(MS_STORE_URI)
    else:
        webbrowser.open(PYTHON_ORG_URL)
    root.destroy()

def find_install_py():
    if getattr(sys, "frozen", False):
        base = os.path.dirname(sys.executable)
    else:
        base = os.path.dirname(os.path.abspath(__file__))
    return os.path.join(base, "install.py")

def main():
    install_py = find_install_py()
    if not os.path.exists(install_py):
        tk.Tk().withdraw()
        messagebox.showerror("install.py が見つかりません", f"同じフォルダに install.py を置いてください。\n期待パス: {install_py}")
        return
    cands = guess_pythons()
    chosen = pick_suitable_python(cands)
    if chosen:
        exe, ver = chosen
        ok = try_run_install_with(exe, install_py)
        if ok:
            return
    for n in ("python3","python"):
        path = shutil.which(n)
        if path:
            res = probe_python_cmd([n])
            if res and (res[1], res[2]) >= MIN_PYVER:
                if try_run_install_with(res[0], install_py):
                    return
    alert_install_python()

if __name__ == "__main__":
    main()
